#!/usr/bin/ruby

require 'yaml'
require 'cgi'
require 'time'
require "selenium-webdriver"

class Cybozu

	attr_accessor :browser
	MAX = 3600

	def initialize(config)
		File.open(config){ | file |
			yaml = YAML.load(file.read())
			@LoginURL = yaml["LoginURL"]
			@LoginName = yaml["LoginName"]
			@Password = yaml["Password"]
			@browser = :firefox
		}
	end
	
	def base_url
		"https://YOUR.CYBOZU.S.BASE.URL/"
	end
	
	def wait_until_url_changed(browser, url)
		MAX.times do
			break if url == browser.current_url
			sleep 1
		end
	end
	
	def login_action

		# init web driver
		browser = Selenium::WebDriver.for @browser

		# Log in
		browser.navigate.to @LoginURL
		browser.find_element(:xpath, "//input[@name='_Account']").send_keys @LoginName
		browser.find_element(:xpath, "//input[@name='Password']").send_keys @Password
		browser.find_element(:xpath, "//input[@name='Submit']").click
		wait_until_url_changed(browser, base_url)
		
		# do caller proc
		yield(browser)
		
		# logout?
		browser.navigate.to base_url
		browser.close
	end
	
	def hyogo_iine
		login_action{ | browser |
			# ready
			url = "#{base_url}page=MyFolderMessageView&mDBID='YOUR_mDBID'&mDID='YOUR_mDID'"
			browser.navigate.to url
			# do
			browser.find_elements(:xpath, "//a[@class='simpleReplyTextLink']").each{| a |
				a.click if a.displayed?
			}
			# wait ajax
			xpath = "//span[@class='simpleReplyUserArea']"
			MAX.times do
				break if browser.find_elements(:xpath, xpath).all?{|span|
					!span.displayed?
				}
			end
			
			puts "done!"
		}
	end

end

if __FILE__ == $0

	config = ARGV.shift
	cybozu = Cybozu.new(config)
	cybozu.hyogo_iine

end

