#!/usr/bin/ruby

$LOAD_PATH.push(File.dirname(__FILE__))
require 'rubygems'
require 'oauth'
#require 'oauth-patch'
require 'yaml'
require 'json'
require 'rubytter'
require 'time'
require 'sixamo'

CONSUMER_KEY = 'CONSUMER_KEY' # ←ここを書き換える
CONSUMER_SECRET = 'CONSUMER_SECRET' # ←ここを書き換える
ACCESS_TOKEN = 'ACCESS_TOKEN' # ←ここを書き換える
ACCESS_TOKEN_SECRET = 'ACCESS_TOKEN_SECRET' # ←ここを書き換える
API_OAUTH = 'http://api.twitter.com'

raise ArgumentError, 'need config' if !ARGV or !ARGV[0] or !ARGV[1]
begin
  rubytter = OAuthRubytter.new(
    OAuth::AccessToken.new(
      OAuth::Consumer.new(CONSUMER_KEY, CONSUMER_SECRET, {:site=>API_OAUTH}),
      ACCESS_TOKEN, ACCESS_TOKEN_SECRET))
  clones = YAML.load_file(File.expand_path(ARGV[0]))
  retweets = YAML.load_file(File.expand_path(ARGV[1]))
rescue
  puts "failed to init."
  exit
end

@clones = {}

#memorize
puts "memorize start #{Time.now}"
clones.each{|clone_id, setting|
  begin
    data_dir = setting["data_dir"]
    id_file  = "#{data_dir}latest_id"
    latest_id = `cat #{id_file}`.gsub(/[\r\n\t\s]/, '')
    option = {:id=>clone_id, :count=>200}
    option[:since_id] = latest_id if latest_id!=""
    count = 0
    sixamo = Sixamo.new(data_dir)
    rubytter.friends_timeline(option).reverse.each {|status|
      next if status[:user][:id] != clone_id
      next if status[:truncated] == true
      next if status[:in_reply_to_status_id]
      texts = nil
      status[:text].split(/\r?\n/).each{|line|
        next if line =~ /https?:\/\/.+/
        text = line.gsub(/[\a\c\e\f\r\t\0]+/, '').gsub(/RT\s*@\w+(.*)$/i, '').gsub(/(。|、|…)/i, '.')
        texts= text.split('.')
      }
      next if !texts
      texts.each{|line|
        next if line == ''
        sixamo.memorize(line.gsub(/[\a\c\e\f\r\t\0]+/, ''))
        puts "memorize: #{line}"
        count += 1
      }
      latest_id = status[:id_str]
      `echo #{latest_id} > #{id_file}`
    }
    puts "memorized #{count} line(s)."
    puts "#{setting["screen_name"]}: #{sixamo.talk}"
    @clones[setting["clone_name"]] = sixamo
  rescue
    puts "#{setting["screen_name"]} failed to memorize."
  end
}

#reply
puts "reply start #{Time.now}"
retweets.each{|name, setting|
  retweets[name]["latest_id"] = `cat #{setting['latest']}`.gsub(/[\r\n\t\s]/, '')
}
rubytter.friends_timeline({:count=>200}).each {|status|
  begin
    next if status[:truncated]
    next if status[:in_reply_to_status_id]
    user = status[:user]
    screen_name = user[:screen_name]
    retweet = retweets[screen_name]
    next if !retweet
    clone = @clones[retweet["clone"]]
    next if !clone or rand(100) > retweet["probable"].to_i
    created = Time.parse(status[:created_at])
    next if created < Time.now - retweet["before_sec"].to_i
    text = status[:text]
    next if text =~ /\s*@\w+(.*)/ or text =~ /https?:\/\/.+/
    status_id = status[:id]
    if retweet['latest_id'].to_i != status_id then
      reply = clone.talk(text.gsub(/[\a\c\e\f\r\t\0]+/, '')) + "\n by #{retweet["clone"]}"
      rubytter.update("@#{screen_name} #{reply}", {:in_reply_to_status_id=>status_id})
      `echo #{status_id} > #{retweet['latest']}`
    end
    retweets.delete(screen_name)
  rescue
    puts "failed to reply"
  end
  puts "@#{screen_name}: #{text} >> #{reply}"
}


