#!/usr/bin/ruby

require "mysql"

class IPv4Range
  HOST = "HOST"
  USER = "USER"
  PASS = "PASS"
  AREA = "AREA"

  def self::setup
    my = Mysql::new(HOST, USER, PASS, AREA)
    my.query("DROP TABLE IF EXISTS `octet`;")
    my.query("DROP TABLE IF EXISTS `range`;")
    my.query <<-"SQL"
      CREATE TABLE `octet` (
        `value` INTEGER NOT NULL ,
        PRIMARY KEY (`value`)
      );
    SQL
    my.query <<-"SQL"
      CREATE TABLE `range` (
        `id` INTEGER NOT NULL AUTO_INCREMENT ,
        `use` BOOLEAN NOT NULL ,
        `prefix` INTEGER NOT NULL ,
        `addr` BIGINT NOT NULL ,
        `mask` BIGINT NOT NULL ,
        `network` BIGINT NOT NULL ,
        `host` BIGINT NOT NULL ,
        `broadcast` BIGINT NOT NULL ,
        `a1` INTEGER NOT NULL ,`a2` INTEGER NOT NULL ,`a3` INTEGER NOT NULL ,`a4` INTEGER NOT NULL ,
        `name` VARCHAR(32) NOT NULL ,
        `memo` MEDIUMTEXT NOT NULL ,
        PRIMARY KEY (`id`)
      );
    SQL
    for octet in 0..255
      my.query("insert into `octet`(`value`)VALUES(#{octet});")
    end
  end

  def self::get_ip_info(o1, o2, o3, o4, prefix)
    full = IPv4Range::dot_to_long(255, 255, 255, 255)
    host_mask = 2**(32-prefix) - 1
    net_mask  = full ^ host_mask
    long = IPv4Range::dot_to_long(o1, o2, o3, o4)
    network = net_mask & long
    host    = host_mask & long
    broadcast = network | host_mask
    {
      :addr      => {:dot => [o1, o2, o3, o4],       :long => long,},
      :mask      => {:dot => long_to_dot(net_mask),  :long => net_mask,},
      :network   => {:dot => long_to_dot(network),   :long => network,},
      :host      => {:dot => long_to_dot(host),      :long => host,},
      :broadcast => {:dot => long_to_dot(broadcast), :long => broadcast,},
    }
  end

  def self::long_to_dot(long)#return [o1,o2,o3,o4]
    ff3, ff2, ff1, ff0 = 256 ** 3, 256 ** 2, 256 ** 1, 256 ** 0
    [(long & (255 * ff3)) / ff3, (long & (255 * ff2)) / ff2, (long & (255 * ff1)) / ff1, (long & (255 * ff0)) / ff0]
  end

  def self::dot_to_long(o1, o2, o3, o4)#return long
    ((((o1 * 256 + o2) * 256) + o3) * 256) + o4
  end
  
  def initialize
    @my = Mysql::new(HOST, USER, PASS, AREA)
  end

  def get_usable_block(o1, o2, o3, o4, prefix, block)#"block" means prefix of usable range
    range  = IPv4Range::get_ip_info(o1, o2, o3, o4, prefix)
    usable = IPv4Range::get_ip_info(o1, o2, o3, o4, block)
    hosts = 2**(32-block)
    network, broadcast = range[:network], range[:broadcast]
    mask = usable[:mask]
    broadcast = network if broadcast == 0
    result = @my.query <<-"SQL"
      SELECT G.`network`, count(G.`network`) FROM (
        SELECT B.* FROM (
          SELECT
             o1.value AS o1, o2.value AS o2, o3.value AS o3, o4.value AS o4
            ,((((( o1.value * 256 +  o2.value) * 256) +  o3.value) * 256) +  o4.value) AS `long`
            ,((((( o1.value * 256 +  o2.value) * 256) +  o3.value) * 256) +  o4.value) & #{mask[:long]} AS `network`
          FROM `octet` AS o1, `octet` AS o2, `octet` AS o3, `octet` AS o4
          WHERE
                o1.value BETWEEN #{network[:dot][0]} AND #{broadcast[:dot][0]}
            AND o2.value BETWEEN #{network[:dot][1]} AND #{broadcast[:dot][1]}
            AND o3.value BETWEEN #{network[:dot][2]} AND #{broadcast[:dot][2]}
            AND o4.value BETWEEN #{network[:dot][3]} AND #{broadcast[:dot][3]}
            AND ((((( o1.value * 256 +  o2.value) * 256) +  o3.value) * 256) +  o4.value) 
                 BETWEEN #{network[:long]} AND #{broadcast[:long]}
        ) AS B
        WHERE NOT EXISTS(
          SELECT 1 FROM `range` AS R WHERE B.long BETWEEN R.`network` AND R.`broadcast`
        )
        ORDER BY B.o1, B.o2, B.o3, B.o4
      ) AS G
      GROUP BY G.`network` HAVING count(G.`network`) >= #{hosts}
      ORDER BY G.`network`
    SQL
  end

  def overlap(o1, o2, o3, o4, prefix)
    info = IPv4Range::get_ip_info(o1, o2, o3, o4, prefix)
    network, broadcast = info[:network][:long], info[:broadcast][:long]
    broadcast = network if broadcast == 0
    result = @my.query <<-"SQL"
      SELECT * FROM `range`
      WHERE `use` != 0 AND (
           `network`   BETWEEN #{network} AND #{broadcast}
        OR `broadcast` BETWEEN #{network} AND #{broadcast}
      )
    SQL
  end

  def overlap?(o1, o2, o3, o4, prefix)
    (overlap(o1, o2, o3, o4, prefix).num_rows > 0)
  end

  def insert_range(o1, o2, o3, o4, prefix, use, name='', memo='')
    info = IPv4Range::get_ip_info(o1, o2, o3, o4, prefix)
    addr,mask,network,host,broadcast = info[:addr],info[:mask],info[:network],info[:host],info[:broadcast]
    @my.query <<-"SQL"
      INSERT INTO `range`(
        `addr`, `a1`, `a2`, `a3`, `a4`,
        `network`, `broadcast`, `mask`, `host`, 
        `prefix`, `use`, `name`, `memo` 
      ) VALUES (
        #{addr[:long]},
        #{addr[:dot][0]},#{addr[:dot][1]},#{addr[:dot][2]},#{addr[:dot][3]},
        #{network[:long]}, #{broadcast[:long]}, #{mask[:long]}, #{host[:long]},     
        #{prefix}, #{use}, '#{name}', '#{memo}' 
      )
    SQL
  end

end

